/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.primitive;

import javax.annotation.ParametersAreNonnullByDefault;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.atlanmod.commons.AbstractTest;
import org.atlanmod.commons.primitive.Strings;
import org.junit.jupiter.api.Test;

@ParametersAreNonnullByDefault
class StringsTest
extends AbstractTest {
    StringsTest() {
    }

    @Test
    void testIsNullOrEmpty() {
        String string0 = "";
        String string1 = null;
        String string2 = "MyString";
        Assertions.assertThat((boolean)Strings.isNullOrEmpty((String)string0)).isTrue();
        Assertions.assertThat((boolean)Strings.isNullOrEmpty(string1)).isTrue();
        Assertions.assertThat((boolean)Strings.isNullOrEmpty((String)string2)).isFalse();
    }

    @Test
    void testNullToEmpty() {
        String string0 = "";
        String string1 = null;
        String string2 = "MyString";
        ((AbstractStringAssert)Assertions.assertThat((String)Strings.nullToEmpty((String)string0)).isNotNull()).isEmpty();
        ((AbstractStringAssert)Assertions.assertThat((String)Strings.nullToEmpty(string1)).isNotNull()).isEmpty();
        Assertions.assertThat((String)Strings.nullToEmpty((String)string2)).isEqualTo(string2);
    }

    @Test
    void testEmptyToNull() {
        String string0 = "";
        String string1 = null;
        String string2 = "MyString";
        Assertions.assertThat((String)Strings.emptyToNull((String)string0)).isNull();
        Assertions.assertThat((String)Strings.emptyToNull(string1)).isNull();
        Assertions.assertThat((String)Strings.emptyToNull((String)string2)).isEqualTo(string2);
    }

    @Test
    void testIsBinary() {
        String string0 = "";
        String string1 = null;
        String string2 = "MyString";
        String string3 = "0123456789ABCDEF";
        String string4 = "0123456789abcdef";
        String string5 = "0123456789aBcdEf";
        String string6 = "G";
        Assertions.assertThat((boolean)Strings.isBinary((String)string0)).isFalse();
        Assertions.assertThat((boolean)Strings.isBinary(string1)).isFalse();
        Assertions.assertThat((boolean)Strings.isBinary((String)string2)).isFalse();
        Assertions.assertThat((boolean)Strings.isBinary((String)string3)).isTrue();
        Assertions.assertThat((boolean)Strings.isBinary((String)string4)).isTrue();
        Assertions.assertThat((boolean)Strings.isBinary((String)string5)).isTrue();
        Assertions.assertThat((boolean)Strings.isBinary((String)string6)).isFalse();
    }

    @Test
    void testToBytes() {
        String string0 = "AtlanmodIsAwesome!";
        byte[] actual0 = Strings.toBytes((String)"AtlanmodIsAwesome!");
        byte[] expected0 = "AtlanmodIsAwesome!".getBytes();
        Assertions.assertThat((byte[])actual0).containsExactly(expected0);
    }
}

