/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.reflect;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import org.assertj.core.api.Assertions;
import org.atlanmod.commons.AbstractTest;
import org.atlanmod.commons.reflect.MoreReflection;
import org.atlanmod.commons.reflect.MoreReflectionTestData;
import org.junit.jupiter.api.Test;

@ParametersAreNonnullByDefault
class MoreReflectionTest
extends AbstractTest {
    MoreReflectionTest() {
    }

    @Test
    void getAllInterfaces() {
        this.assertImplements(Object.class, new Class[0]);
        this.assertImplements(File.class, Serializable.class, Comparable.class);
        this.assertImplements(ArrayList.class, List.class, Collection.class, Iterable.class, RandomAccess.class, Cloneable.class, Serializable.class);
    }

    private void assertImplements(Class<?> type, Class<?> ... interfaces) {
        Set set = MoreReflection.getAllInterfaces(type);
        Assertions.assertThat((Iterable)set).containsExactlyInAnyOrder((Object[])interfaces);
    }

    @Test
    void matchesCompatibleSignature() {
        Optional<Method> threeParametersMethod = Stream.of(MoreReflectionTestData.class.getMethods()).filter(each -> "aMethodWithThreeParameters".equals(each.getName())).findFirst();
        Class[] args = new Class[]{String.class, Integer.class, List.class};
        Assertions.assertThat((boolean)MoreReflection.matches((Executable)threeParametersMethod.get(), (Class[])args)).isTrue();
    }

    @Test
    void doesNotMatchIncompatibleSignature() {
        Optional<Method> threeParametersMethod = Stream.of(MoreReflectionTestData.class.getMethods()).filter(each -> "aMethodWithThreeParameters".equals(each.getName())).findFirst();
        Class[] wrongSignature = new Class[]{Integer.class, String.class, List.class};
        Assertions.assertThat((boolean)MoreReflection.matches((Executable)threeParametersMethod.get(), (Class[])wrongSignature)).isFalse();
    }

    @Test
    void getInstantiatorWithConstructor() {
        Function instantiator = MoreReflection.getInstantiator(MoreReflectionTestData.class, (Class[])new Class[]{String.class});
        MoreReflectionTestData newInstance = (MoreReflectionTestData)instantiator.apply(new Object[]{"constructor"});
        Assertions.assertThat((Object)newInstance).isNotNull();
        Assertions.assertThat((String)newInstance.name()).isEqualTo("constructor");
    }

    @Test
    void getInstantiatorWithFactoryMethod() {
        Function instantiator = MoreReflection.getInstantiator(MoreReflectionTestData.class, (Class[])new Class[0]);
        MoreReflectionTestData newInstance = (MoreReflectionTestData)instantiator.apply(new Object[0]);
        Assertions.assertThat((Object)newInstance).isNotNull();
        Assertions.assertThat((String)newInstance.name()).isEqualTo("factory");
    }
}

