/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons;

import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class LazyInt {
    @Nonnull
    private final IntSupplier loadFunction;
    private int value;
    private volatile boolean isLoaded;

    private LazyInt(IntSupplier loadFunction) {
        this.loadFunction = loadFunction;
    }

    @Nonnull
    public static LazyInt of(int value) {
        return new LazyInt(() -> value);
    }

    @Nonnull
    public static LazyInt with(IntSupplier loadFunction) {
        return new LazyInt(loadFunction);
    }

    public int getAsInt() {
        if (!this.isLoaded) {
            this.load();
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        IntSupplier intSupplier = this.loadFunction;
        synchronized (intSupplier) {
            if (!this.isLoaded) {
                this.update(this.loadFunction.getAsInt());
            }
        }
    }

    public void update(int newValue) {
        this.value = newValue;
        this.isLoaded = true;
    }

    public void update(IntUnaryOperator updateOperator) {
        this.update(updateOperator.applyAsInt(this.getAsInt()));
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void ifLoaded(IntConsumer consumer) {
        if (this.isLoaded) {
            consumer.accept(this.value);
        }
    }

    public void unload() {
        this.value = 0;
        this.isLoaded = false;
    }
}

