/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.cache;

import java.util.function.Function;
import java.util.function.ToIntBiFunction;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.atlanmod.commons.annotation.Builder;
import org.atlanmod.commons.cache.Cache;
import org.atlanmod.commons.cache.CaffeineCacheBuilder;
import org.atlanmod.commons.cache.EmptyCache;

@Builder(value="builder")
public interface CacheBuilder<K, V> {
    @Nonnull
    public static <K, V> Cache<K, V> empty() {
        return EmptyCache.getInstance();
    }

    @Nonnull
    public static CacheBuilder<Object, Object> builder() {
        return new CaffeineCacheBuilder<Object, Object>();
    }

    @Nonnull
    public CacheBuilder<K, V> recordStats();

    @Nonnull
    public CacheBuilder<K, V> initialCapacity(@Nonnegative int var1);

    @Nonnull
    public CacheBuilder<K, V> maximumSize(@Nonnegative long var1);

    public <K1 extends K, V1 extends V> CacheBuilder<K, V> maximumWeight(@Nonnegative long var1, ToIntBiFunction<? super K1, ? extends V1> var3);

    @Nonnull
    public CacheBuilder<K, V> weakKeys();

    @Nonnull
    public CacheBuilder<K, V> weakValues();

    @Nonnull
    public CacheBuilder<K, V> softValues();

    @Nonnull
    public <K1 extends K, V1 extends V> Cache<K1, V1> build();

    @Nonnull
    public <K1 extends K, V1 extends V> Cache<K1, V1> build(Function<? super K1, ? extends V1> var1);
}

