/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.cache;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Preconditions;
import org.atlanmod.commons.cache.CaffeineManualCache;

@ParametersAreNonnullByDefault
class CaffeineLoadingCache<C extends LoadingCache<K, V>, K, V>
extends CaffeineManualCache<C, K, V> {
    protected CaffeineLoadingCache(C cache) {
        super(cache);
    }

    @Override
    @Nullable
    public V get(K key) {
        Preconditions.checkNotNull(key, "key");
        return (V)((LoadingCache)this.cache).get(key);
    }

    @Override
    @Nonnull
    public Map<K, V> getAll(Iterable<? extends K> keys) {
        Preconditions.checkNotNull(keys, "keys");
        return ((LoadingCache)this.cache).getAll(keys);
    }

    @Override
    public void refresh(K key) {
        Preconditions.checkNotNull(key, "key");
        ((LoadingCache)this.cache).refresh(key);
    }
}

