/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.cache;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.atlanmod.commons.annotation.Singleton;
import org.atlanmod.commons.cache.Cache;
import org.atlanmod.commons.cache.CacheStats;

@Singleton
@ParametersAreNonnullByDefault
@Immutable
class EmptyCache<K, V>
implements Cache<K, V> {
    private static final Cache<Object, Object> INSTANCE = new EmptyCache<Object, Object>();

    EmptyCache() {
    }

    @Nonnull
    public static <K, V> Cache<K, V> getInstance() {
        return INSTANCE;
    }

    @Override
    public V get(K key) {
        return null;
    }

    @Override
    public V get(K key, Function<? super K, ? extends V> mappingFunction) {
        return mappingFunction.apply(key);
    }

    @Override
    @Nonnull
    public Map<K, V> getAll(Iterable<? extends K> keys) {
        return Collections.emptyMap();
    }

    @Override
    public void put(K key, V value) {
    }

    @Override
    public void putIfAbsent(K key, V value) {
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
    }

    @Override
    public void invalidate(K key) {
    }

    @Override
    public void invalidateAll(Iterable<? extends K> keys) {
    }

    @Override
    public void invalidateAll() {
    }

    @Override
    public boolean contains(K key) {
        return false;
    }

    @Override
    @Nonnegative
    public long size() {
        return 0L;
    }

    @Override
    public void refresh(K key) {
    }

    @Override
    public void cleanUp() {
    }

    @Override
    @Nonnull
    public ConcurrentMap<K, V> asMap() {
        return new ConcurrentHashMap(0);
    }

    @Override
    @Nonnull
    public CacheStats stats() {
        return new CacheStats(0L, 0L, 0L, 0L, 0L, 0L);
    }
}

