/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.collect;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;
import java.util.function.LongUnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Throwables;
import org.atlanmod.commons.annotation.Static;

@Static
@ParametersAreNonnullByDefault
public final class MoreStreams {
    private MoreStreams() {
        throw Throwables.notInstantiableClass(this.getClass());
    }

    @Nonnull
    public static Optional<Integer> indexOf(Stream<?> stream, Object value) {
        AtomicInteger currentIndex = new AtomicInteger(-1);
        boolean found = stream.peek(e -> currentIndex.incrementAndGet()).anyMatch(e -> Objects.equals(e, value));
        return found ? Optional.of(currentIndex.get()) : Optional.empty();
    }

    @Nonnull
    public static Optional<Integer> lastIndexOf(Stream<?> stream, Object value) {
        AtomicInteger currentIndex = new AtomicInteger(-1);
        AtomicInteger lastIndex = new AtomicInteger(-1);
        stream.peek(e -> currentIndex.incrementAndGet()).filter(e -> Objects.equals(e, value)).forEach(e -> lastIndex.set(currentIndex.intValue()));
        return lastIndex.get() >= 0 ? Optional.of(lastIndex.get()) : Optional.empty();
    }

    @Nonnull
    public static Optional<Integer> size(Stream<?> stream) {
        return Optional.of(stream.count()).map(Long::intValue).filter(s -> s > 0);
    }

    @Nonnull
    public static IntUnaryOperator reverseOrder(int startInclusive, int endExclusive) {
        return i -> endExclusive - i + startInclusive - 1;
    }

    @Nonnull
    public static LongUnaryOperator reverseOrder(long startInclusive, long endExclusive) {
        return i -> endExclusive - i + startInclusive - 1L;
    }
}

