/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.function;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Preconditions;

@ParametersAreNonnullByDefault
public interface Converter<T, R>
extends Function<T, R> {
    @Nonnull
    public static <T> Converter<T, T> identity() {
        return new Converter<T, T>(){

            @Override
            public T convert(T t) {
                return t;
            }

            @Override
            public T revert(T t) {
                return t;
            }
        };
    }

    @Nonnull
    public static <T, R> Converter<T, R> from(final Function<? super T, ? extends R> convertFunc, final Function<? super R, ? extends T> revertFunc) {
        Preconditions.checkNotNull(convertFunc, "convertFunc");
        Preconditions.checkNotNull(revertFunc, "revertFunc");
        return new Converter<T, R>(){

            @Override
            public R convert(T t) {
                return convertFunc.apply(t);
            }

            @Override
            public T revert(R r) {
                return revertFunc.apply(r);
            }
        };
    }

    @Nonnull
    public static <T, U, R> Converter<T, R> compose(final Converter<T, U> before, final Converter<U, R> after) {
        Preconditions.checkNotNull(before, "before");
        Preconditions.checkNotNull(after, "after");
        return new Converter<T, R>(){

            @Override
            public R convert(T t) {
                return after.convert(before.convert(t));
            }

            @Override
            public T revert(R r) {
                return before.revert(after.revert(r));
            }
        };
    }

    @Override
    default public R apply(T t) {
        return this.convert(t);
    }

    public R convert(T var1);

    public T revert(R var1);

    @Nonnull
    default public Converter<R, T> reverse() {
        return Converter.from(this::revert, this::convert);
    }
}

