/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.io.serializer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillNotClose;
import org.atlanmod.commons.io.serializer.BinarySerializer;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;

@ParametersAreNonnullByDefault
public abstract class AbstractBinarySerializer<T>
implements BinarySerializer<T> {
    @Nonnull
    static final FSTConfiguration FST = FSTConfiguration.createDefaultConfiguration();

    @Override
    @Nonnull
    public byte[] serialize(T t) throws IOException {
        FSTObjectOutput out = FST.getObjectOutput();
        this.serialize(t, (DataOutput)out);
        return out.getCopyOfWrittenBuffer();
    }

    @Override
    @Nonnull
    public T deserialize(byte[] data) throws IOException {
        FSTObjectInput in = FST.getObjectInput(data);
        return this.deserialize((DataInput)in);
    }

    @Override
    public void serialize(T t, @WillNotClose OutputStream os) throws IOException {
        FSTObjectOutput out = FST.getObjectOutput(os);
        this.serialize(t, (DataOutput)out);
        out.flush();
    }

    @Override
    @Nonnull
    public T deserialize(@WillNotClose InputStream is) throws IOException {
        FSTObjectInput in = FST.getObjectInput(is);
        return this.deserialize((DataInput)in);
    }
}

