/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.cache;

import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.atlanmod.commons.Preconditions;

@ParametersAreNonnullByDefault
@Immutable
public final class CacheStats {
    @Nonnegative
    private final long hitCount;
    @Nonnegative
    private final long missCount;
    @Nonnegative
    private final long loadSuccessCount;
    @Nonnegative
    private final long loadFailureCount;
    @Nonnegative
    private final long totalLoadTime;
    @Nonnegative
    private final long evictionCount;

    protected CacheStats(@Nonnegative long hitCount, @Nonnegative long missCount, @Nonnegative long loadSuccessCount, @Nonnegative long loadFailureCount, @Nonnegative long totalLoadTime, @Nonnegative long evictionCount) {
        Preconditions.checkGreaterThanOrEqualTo(hitCount, 0L, "hitCount (%d) must not be negative", hitCount);
        Preconditions.checkGreaterThanOrEqualTo(missCount, 0L, "missCount (%d) must not be negative", missCount);
        Preconditions.checkGreaterThanOrEqualTo(loadSuccessCount, 0L, "loadSuccessCount (%d) must not be negative", loadSuccessCount);
        Preconditions.checkGreaterThanOrEqualTo(loadFailureCount, 0L, "loadFailureCount (%d) must not be negative", loadFailureCount);
        Preconditions.checkGreaterThanOrEqualTo(totalLoadTime, 0L, "totalLoadTime (%d) must not be negative", totalLoadTime);
        Preconditions.checkGreaterThanOrEqualTo(evictionCount, 0L, "evictionCount (%d) must not be negative", evictionCount);
        this.hitCount = hitCount;
        this.missCount = missCount;
        this.loadSuccessCount = loadSuccessCount;
        this.loadFailureCount = loadFailureCount;
        this.totalLoadTime = totalLoadTime;
        this.evictionCount = evictionCount;
    }

    @Nonnegative
    public long requestCount() {
        return this.hitCount + this.missCount;
    }

    @Nonnegative
    public long hitCount() {
        return this.hitCount;
    }

    @Nonnegative
    public double hitRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 1.0 : (double)this.hitCount / (double)requestCount;
    }

    @Nonnegative
    public long missCount() {
        return this.missCount;
    }

    @Nonnegative
    public double missRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 0.0 : (double)this.missCount / (double)requestCount;
    }

    @Nonnegative
    public long loadCount() {
        return this.loadSuccessCount + this.loadFailureCount;
    }

    @Nonnegative
    public long loadSuccessCount() {
        return this.loadSuccessCount;
    }

    @Nonnegative
    public long loadFailureCount() {
        return this.loadFailureCount;
    }

    @Nonnegative
    public double loadFailureRate() {
        long loadCount = this.loadCount();
        return loadCount == 0L ? 0.0 : (double)this.loadFailureCount / (double)loadCount;
    }

    @Nonnegative
    public Duration totalLoadTime() {
        return Duration.ofNanos(this.totalLoadTime);
    }

    @Nonnegative
    public double averageLoadPenalty() {
        long loadCount = this.loadCount();
        return loadCount == 0L ? 0.0 : (double)this.totalLoadTime / (double)loadCount;
    }

    @Nonnegative
    public long evictionCount() {
        return this.evictionCount;
    }

    @Nonnull
    public CacheStats minus(CacheStats other) {
        return new CacheStats(Math.max(0L, this.hitCount - other.hitCount), Math.max(0L, this.missCount - other.missCount), Math.max(0L, this.loadSuccessCount - other.loadSuccessCount), Math.max(0L, this.loadFailureCount - other.loadFailureCount), Math.max(0L, this.totalLoadTime - other.totalLoadTime), Math.max(0L, this.evictionCount - other.evictionCount));
    }

    @Nonnull
    public CacheStats plus(CacheStats other) {
        return new CacheStats(this.hitCount + other.hitCount, this.missCount + other.missCount, this.loadSuccessCount + other.loadSuccessCount, this.loadFailureCount + other.loadFailureCount, this.totalLoadTime + other.totalLoadTime, this.evictionCount + other.evictionCount);
    }

    public int hashCode() {
        return Objects.hash(this.hitCount, this.missCount, this.loadSuccessCount, this.loadFailureCount, this.totalLoadTime, this.evictionCount);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheStats that = (CacheStats)o;
        return this.hitCount == that.hitCount && this.missCount == that.missCount && this.loadSuccessCount == that.loadSuccessCount && this.loadFailureCount == that.loadFailureCount && this.totalLoadTime == that.totalLoadTime && this.evictionCount == that.evictionCount;
    }

    public String toString() {
        return String.format("CacheStats {Hit = %d (%.0f%%), Miss = %d (%.0f%%), Eviction Count = %d}", this.hitCount(), this.hitRate() * 100.0, this.missCount(), this.missRate() * 100.0, this.evictionCount());
    }
}

