/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.collect;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Preconditions;
import org.atlanmod.commons.Throwables;
import org.atlanmod.commons.annotation.Static;

@Static
@ParametersAreNonnullByDefault
public final class MoreArrays {
    public static final int NO_INDEX = -1;

    private MoreArrays() {
        throw Throwables.notInstantiableClass(this.getClass());
    }

    @Nonnull
    public static <T> T[] newArray(Class<?> type, @Nonnegative int length) {
        Preconditions.checkNotNull(type, "type");
        Preconditions.checkGreaterThanOrEqualTo(length, 0, "length (%d) must not be negative", length);
        return type == Object.class ? new Object[length] : (Object[])Array.newInstance(type, length);
    }

    @Nonnull
    public static <T> T[] set(T[] array, @Nonnegative int index, @Nullable T value) {
        Preconditions.checkNotNull(array, "array");
        array[index] = value;
        return array;
    }

    @Nonnull
    public static <T> T[] resize(T[] array, @Nonnegative int length) {
        Preconditions.checkNotNull(array, "array");
        Preconditions.checkGreaterThanOrEqualTo(length, array.length, "length (%d) must be not less than array.length (%d)", length, array.length);
        T[] newArray = MoreArrays.newArray(array.getClass().getComponentType(), length);
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    @Nonnull
    public static <T> T[] append(T[] array, @Nullable T element) {
        return MoreArrays.add(array, array.length, element);
    }

    @Nonnull
    public static <T> T[] add(T[] array, @Nonnegative int index, @Nullable T element) {
        Preconditions.checkNotNull(array, "array");
        Preconditions.checkElementIndex(index, array.length + 1);
        T[] newArray = MoreArrays.newArray(array.getClass().getComponentType(), array.length + 1);
        System.arraycopy(array, 0, newArray, 0, index);
        newArray[index] = element;
        if (index < array.length) {
            System.arraycopy(array, index, newArray, index + 1, array.length - index);
        }
        return newArray;
    }

    @Nonnull
    public static <T> T[] addAll(T[] array, int index, Collection<? extends T> elements) {
        Preconditions.checkNotNull(array, "array");
        Preconditions.checkNotNull(elements, "elements");
        T[] newArray = MoreArrays.newArray(array.getClass().getComponentType(), array.length + elements.size());
        System.arraycopy(array, 0, newArray, 0, index);
        int i = 0;
        for (T e : elements) {
            newArray[index + i] = e;
            ++i;
        }
        if (index < array.length) {
            System.arraycopy(array, index, newArray, index + elements.size(), array.length - index);
        }
        return newArray;
    }

    @Nonnull
    public static byte[] addAll(byte[] array1, byte ... array2) {
        Preconditions.checkNotNull(array1, "array1");
        Preconditions.checkNotNull(array2, "array2");
        byte[] newArray = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, newArray, 0, array1.length);
        System.arraycopy(array2, 0, newArray, array1.length, array2.length);
        return newArray;
    }

    @Nonnull
    public static <T> T[] remove(T[] array, @Nonnegative int index) {
        Preconditions.checkNotNull(array, "array");
        Preconditions.checkElementIndex(index, array.length);
        T[] newArray = MoreArrays.newArray(array.getClass().getComponentType(), array.length - 1);
        System.arraycopy(array, 0, newArray, 0, index);
        if (index < array.length - 1) {
            System.arraycopy(array, index + 1, newArray, index, array.length - index - 1);
        }
        return newArray;
    }

    public static <T> boolean contains(T[] array, @Nullable T value) {
        Preconditions.checkNotNull(array, "array");
        return MoreArrays.indexOf(array, value) != -1;
    }

    public static <T> int indexOf(T[] array, @Nullable T value) {
        Preconditions.checkNotNull(array, "array");
        for (int i = 0; i < array.length; ++i) {
            if (!Objects.equals(value, array[i])) continue;
            return i;
        }
        return -1;
    }

    public static <T> int lastIndexOf(T[] array, @Nullable T value) {
        Preconditions.checkNotNull(array, "array");
        for (int i = array.length - 1; i >= 0; --i) {
            if (!Objects.equals(value, array[i])) continue;
            return i;
        }
        return -1;
    }

    @Nonnull
    public static byte[] toPrimitive(Byte ... boxedArray) {
        Preconditions.checkNotNull(boxedArray, "boxedArray");
        int size = boxedArray.length;
        byte[] primitiveArray = new byte[size];
        for (int i = 0; i < size; ++i) {
            primitiveArray[i] = boxedArray[i];
        }
        return primitiveArray;
    }

    public static Byte[] toObject(byte ... primitiveArray) {
        Preconditions.checkNotNull(primitiveArray, "primitiveArray");
        int size = primitiveArray.length;
        Byte[] boxedArray = new Byte[size];
        for (int i = 0; i < size; ++i) {
            boxedArray[i] = primitiveArray[i];
        }
        return boxedArray;
    }
}

