/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.concurrent;

import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Preconditions;
import org.atlanmod.commons.Throwables;
import org.atlanmod.commons.annotation.Static;

@Static
@ParametersAreNonnullByDefault
public final class MoreThreads {
    @Nonnull
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = MoreThreads.newThreadFactory("shutdown-hook-manager");

    private MoreThreads() {
        throw Throwables.notInstantiableClass(this.getClass());
    }

    @Nonnull
    public static ThreadFactory newThreadFactory() {
        return MoreThreads.newThreadFactory(null);
    }

    @Nonnull
    public static ThreadFactory newThreadFactory(@Nullable String prefix) {
        AtomicInteger threadCount = new AtomicInteger(1);
        return task -> {
            Thread thread = Executors.defaultThreadFactory().newThread(task);
            thread.setDaemon(true);
            if (Objects.nonNull(prefix)) {
                thread.setName(prefix + "-" + threadCount.getAndIncrement());
            }
            return thread;
        };
    }

    public static void executeAtExit(Runnable task) {
        Preconditions.checkNotNull(task, "task");
        Runtime.getRuntime().addShutdownHook(DEFAULT_THREAD_FACTORY.newThread(task));
    }
}

