/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.hash;

import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.atlanmod.commons.hash.HashCode;
import org.atlanmod.commons.primitive.Longs;

@ParametersAreNonnullByDefault
@Immutable
final class LongHashCode
implements HashCode {
    private static final long serialVersionUID = 6258681675820336026L;
    private final long value;

    public LongHashCode(long value) {
        this.value = value;
    }

    @Override
    @Nonnegative
    public int bits() {
        return 64;
    }

    @Override
    @Nonnull
    public byte[] toBytes() {
        return Longs.toBytes(this.value);
    }

    @Override
    public long toLong() {
        return this.value;
    }

    @Override
    @Nonnull
    public String toHexString() {
        return Long.toHexString(this.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongHashCode that = (LongHashCode)o;
        return this.value == that.value;
    }

    public String toString() {
        return String.format("HashCode {%s}", this.toHexString());
    }
}

