/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.hash;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.openhft.hashing.LongHashFunction;
import org.atlanmod.commons.Throwables;
import org.atlanmod.commons.annotation.Static;
import org.atlanmod.commons.hash.Hasher;
import org.atlanmod.commons.hash.NativeHasher;
import org.atlanmod.commons.hash.ZeroAllocationHasher;

@Static
@ParametersAreNonnullByDefault
public final class StandardHashers {
    @Nonnull
    public static final Hasher MD5 = new NativeHasher("MD5");
    @Nonnull
    public static final Hasher SHA1 = new NativeHasher("SHA-1");
    @Nonnull
    public static final Hasher SHA256 = new NativeHasher("SHA-256");
    @Nonnull
    public static final Hasher MURMUR3 = new ZeroAllocationHasher(LongHashFunction.murmur_3());
    @Nonnull
    public static final Hasher XX = new ZeroAllocationHasher(LongHashFunction.xx());
    @Nonnull
    public static final Hasher CITY = new ZeroAllocationHasher(LongHashFunction.city_1_1());
    @Nonnull
    public static final Hasher FARM_NA = new ZeroAllocationHasher(LongHashFunction.farmNa());
    @Nonnull
    public static final Hasher FARM_UO = new ZeroAllocationHasher(LongHashFunction.farmUo());

    private StandardHashers() {
        throw Throwables.notInstantiableClass(this.getClass());
    }

    @Nonnull
    public static Hasher forName(String name) {
        try {
            return (Hasher)StandardHashers.class.getDeclaredField(name).get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            String possibleValues = Arrays.stream(StandardHashers.class.getDeclaredFields()).filter(f -> f.getType().isAssignableFrom(Hasher.class)).filter(f -> Modifier.isStatic(f.getModifiers())).map(Field::getName).collect(Collectors.joining(" | "));
            throw new IllegalArgumentException(String.format("Unable to retrieve a Hasher with name '%s'. Possible values: %s", name, possibleValues), e);
        }
    }
}

