/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.log;

import java.text.MessageFormat;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.atlanmod.commons.concurrent.MoreExecutors;
import org.atlanmod.commons.log.Level;
import org.atlanmod.commons.log.Log;
import org.atlanmod.commons.log.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@ThreadSafe
@Immutable
class AsyncLogger
implements Logger {
    @Nonnull
    private static final ExecutorService POOL = MoreExecutors.newFixedThreadPool(1);
    @Nonnull
    private final org.slf4j.Logger logger;

    public AsyncLogger(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }

    @Override
    public void log(Level level, @Nullable Throwable e, @Nullable CharSequence message, Object ... params) {
        if (!level.isEnabledFor(this.logger)) {
            return;
        }
        Function<String, String> formatFunc = m -> Objects.nonNull(params) && params.length > 0 ? MessageFormat.format(m, params) : m;
        this.execute(() -> {
            try {
                String formattedMessage = Optional.ofNullable(message).map(CharSequence::toString).map(formatFunc).orElse(null);
                level.logWith(this.logger, formattedMessage, e);
            }
            catch (Exception fe) {
                Log.error(fe);
            }
        });
    }

    private void execute(Runnable runnable) {
        try {
            POOL.submit(runnable);
        }
        catch (RejectedExecutionException e) {
            runnable.run();
        }
    }

    static {
        System.setProperty("org.slf4j.simpleLogger.showThreadName", "false");
        System.setProperty("org.slf4j.simpleLogger.showLogName", "false");
        System.setProperty("org.slf4j.simpleLogger.levelInBrackets", "true");
    }
}

