/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.service;

import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Lazy;
import org.atlanmod.commons.annotation.Singleton;
import org.atlanmod.commons.annotation.Static;
import org.atlanmod.commons.service.ServiceContext;
import org.atlanmod.commons.service.ServiceDefinition;
import org.atlanmod.commons.service.ServiceLoaderContext;

@Singleton
@ParametersAreNonnullByDefault
public final class ServiceProvider {
    @Nonnull
    private final Lazy<ServiceContext> provider = Lazy.with(ServiceLoaderContext::new);

    private ServiceProvider() {
    }

    @Nonnull
    public static ServiceProvider getInstance() {
        return Holder.INSTANCE;
    }

    void setContext(ServiceContext context) {
        this.provider.update(context);
    }

    void unloadContext() {
        this.provider.update(new ServiceLoaderContext());
    }

    @Nonnull
    public <S> Stream<ServiceDefinition<S>> load(Class<S> type) {
        return this.provider.get().getServices(type);
    }

    @Static
    private static final class Holder {
        static final ServiceProvider INSTANCE = new ServiceProvider();

        private Holder() {
        }
    }
}

