/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.collect;

import java.util.ListIterator;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Guards;
import org.atlanmod.commons.function.Converter;

@ParametersAreNonnullByDefault
public class DelegatedListIterator<T, R>
implements ListIterator<R> {
    @Nonnull
    private final ListIterator<T> delegate;
    @Nonnull
    private final Converter<T, R> converter;

    public DelegatedListIterator(ListIterator<T> delegate, Converter<T, R> converter) {
        Guards.checkNotNull(delegate, "delegate");
        Guards.checkNotNull(converter, "converter");
        this.delegate = delegate;
        this.converter = converter;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public R next() {
        return this.converter.convert(this.delegate.next());
    }

    @Override
    public boolean hasPrevious() {
        return this.delegate.hasPrevious();
    }

    @Override
    public R previous() {
        return this.converter.convert(this.delegate.previous());
    }

    @Override
    public int nextIndex() {
        return this.delegate.nextIndex();
    }

    @Override
    public int previousIndex() {
        return this.delegate.previousIndex();
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }

    @Override
    public void set(R r) {
        this.delegate.set(this.converter.revert(r));
    }

    @Override
    public void add(R r) {
        this.delegate.add(this.converter.revert(r));
    }
}

