/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.collect;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.atlanmod.commons.Guards;
import org.atlanmod.commons.collect.MoreIterables;

@ParametersAreNonnullByDefault
@Immutable
public interface IntRange {
    @Nonnull
    public static IntRange open(int lower, int upper) {
        Guards.checkLessThanOrEqualTo(lower, upper, "upper (%d) must not be less than lower (%d)", upper, lower);
        return v -> v > lower && v < upper;
    }

    @Nonnull
    public static IntRange closed(int lower, int upper) {
        Guards.checkLessThanOrEqualTo(lower, upper, "upper (%d) must not be less than lower (%d)", upper, lower);
        return v -> v >= lower && v <= upper;
    }

    @Nonnull
    public static IntRange openClosed(int lower, int upper) {
        Guards.checkLessThanOrEqualTo(lower, upper, "upper (%d) must not be less than lower (%d)", upper, lower);
        return v -> v > lower && v <= upper;
    }

    @Nonnull
    public static IntRange closedOpen(int lower, int upper) {
        Guards.checkLessThanOrEqualTo(lower, upper, "upper (%d) must not be less than lower (%d)", upper, lower);
        return v -> v >= lower && v < upper;
    }

    @Nonnull
    public static IntRange singleton(int value) {
        return IntRange.closed(value, value);
    }

    @Nonnull
    public static IntRange atLeast(int lower) {
        return v -> v >= 0;
    }

    @Nonnull
    public static IntRange atMost(int upper) {
        return v -> v <= upper;
    }

    @Nonnull
    public static IntRange greaterThan(int lower) {
        return v -> v > lower;
    }

    @Nonnull
    public static IntRange lessThan(int upper) {
        return v -> v < upper;
    }

    @Nonnull
    public static IntRange all() {
        return v -> true;
    }

    @Nonnull
    public static IntRange empty() {
        return v -> false;
    }

    @Nonnull
    public static IntRange and(IntRange r1, IntRange r2) {
        Guards.checkNotNull(r1, "r1");
        Guards.checkNotNull(r2, "r2");
        return v -> Boolean.logicalAnd(r1.contains(v), r2.contains(v));
    }

    @Nonnull
    public static IntRange or(IntRange r1, IntRange r2) {
        Guards.checkNotNull(r1, "r1");
        Guards.checkNotNull(r2, "r2");
        return v -> Boolean.logicalOr(r1.contains(v), r2.contains(v));
    }

    @Nonnull
    public static IntRange xor(IntRange r1, IntRange r2) {
        Guards.checkNotNull(r1, "r1");
        Guards.checkNotNull(r2, "r2");
        return v -> Boolean.logicalXor(r1.contains(v), r2.contains(v));
    }

    public boolean contains(int var1);

    default public boolean containsAll(Iterable<Integer> values) {
        Guards.checkNotNull(values, "values");
        return MoreIterables.stream(values).allMatch(this::contains);
    }
}

