/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.collect;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Guards;

@ParametersAreNonnullByDefault
public class Path<T> {
    private final T[] values;

    @SafeVarargs
    private Path(T ... values) {
        this.values = Objects.requireNonNull(values);
    }

    public int size() {
        return this.values.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Path)) {
            return false;
        }
        Path other = (Path)o;
        return Arrays.equals(this.values, other.values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public String toString() {
        return Arrays.toString(this.values);
    }

    public T last() {
        return this.get(this.values.length - 1);
    }

    public T head() {
        return this.get(0);
    }

    public Path<T> tail() {
        Guards.checkState(this.values.length > 1);
        return new Path<T>(Arrays.copyOfRange(this.values, 1, this.values.length));
    }

    private T get(int index) {
        return this.values[Guards.checkElementIndex(index, this.values.length)];
    }

    @SafeVarargs
    public static <E> Path<E> of(E ... values) {
        return new Path<E>(Arrays.copyOf(Guards.checkNotNull(values), values.length));
    }
}

