/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.collect;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.IntFunction;
import javax.annotation.Nonnegative;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Guards;

@ParametersAreNonnullByDefault
public class SizedIterator<E>
implements Iterator<E> {
    @Nonnegative
    private final IntFunction<E> mappingFunction;
    @Nonnegative
    private final int size;
    @Nonnegative
    private int index;

    public SizedIterator(@Nonnegative int size, IntFunction<E> mappingFunction) {
        this(size, mappingFunction, 0);
    }

    public SizedIterator(@Nonnegative int size, IntFunction<E> mappingFunction, @Nonnegative int index) {
        Guards.checkNotNull(mappingFunction, "mappingFunction");
        Guards.checkPositionIndex(index, size);
        this.size = size;
        this.index = index;
        this.mappingFunction = mappingFunction;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.size;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.mappingFunction.apply(this.index++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

