/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.collect;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.function.IntFunction;
import javax.annotation.Nonnegative;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Guards;

@ParametersAreNonnullByDefault
public class SizedListIterator<E>
implements ListIterator<E> {
    @Nonnegative
    private final IntFunction<E> mappingFunction;
    @Nonnegative
    private final int size;
    @Nonnegative
    private int index;

    public SizedListIterator(@Nonnegative int size, IntFunction<E> mappingFunction) {
        this(size, mappingFunction, 0);
    }

    public SizedListIterator(@Nonnegative int size, IntFunction<E> mappingFunction, int index) {
        Guards.checkNotNull(mappingFunction, "mappingFunction");
        Guards.checkPositionIndex(index, size);
        this.size = size;
        this.index = index;
        this.mappingFunction = mappingFunction;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.size;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.mappingFunction.apply(this.index++);
    }

    @Override
    public boolean hasPrevious() {
        return this.index > 0;
    }

    @Override
    public E previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        return this.mappingFunction.apply(--this.index);
    }

    @Override
    public int nextIndex() {
        return this.index;
    }

    @Override
    public int previousIndex() {
        return this.index - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public void set(E e) {
        throw new UnsupportedOperationException("set");
    }

    @Override
    public void add(E e) {
        throw new UnsupportedOperationException("add");
    }
}

