/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.collect;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Guards;
import org.atlanmod.commons.collect.MoreArrays;

@ParametersAreNonnullByDefault
public class Tree<T>
implements Iterable<T> {
    private final Node root = new RootNode();

    @SafeVarargs
    public final void add(T ... path) {
        Guards.checkNotNull(path, "path");
        this.root.add(path);
    }

    public boolean isEmpty() {
        return this.root.size == 0;
    }

    public String toString() {
        return this.root.toString();
    }

    public List<T> leaves() {
        return this.root.leaves();
    }

    @Override
    public Iterator<T> iterator() {
        return new BreadthFirstTreeIterator(this.root);
    }

    class RootNode
    extends Node {
        RootNode() {
        }

        @Override
        public String toString() {
            return "ROOT" + super.toString();
        }

        @Override
        void collectLeaves(List<T> collectedLeaves) {
            if (this.isLeaf()) {
                return;
            }
            for (int i = 0; i < this.size; ++i) {
                this.nodes[i].collectLeaves(collectedLeaves);
            }
        }

        @Override
        public List<Node> path() {
            return new LinkedList<Node>();
        }
    }

    abstract class Node {
        ContentNode[] nodes = (ContentNode[])MoreArrays.newArray(ContentNode.class, 0);
        int size = 0;

        Node() {
        }

        private int indexOf(T value) {
            for (int i = 0; i < this.size; ++i) {
                if (!value.equals(this.nodes[i].content)) continue;
                return i;
            }
            return -1;
        }

        @SafeVarargs
        public final void add(T ... path) {
            Guards.checkNotNull(path, "path");
            if (path.length == 0) {
                return;
            }
            int position = this.indexOf(MoreArrays.head(path));
            Node child = position < 0 ? this.addChild(MoreArrays.head(path)) : this.getChild(position);
            child.add(MoreArrays.tail(path));
        }

        private Node addChild(T childContent) {
            this.ensureCapacity(this.size + 1);
            ContentNode newNode = new ContentNode(this, childContent);
            this.nodes[this.size++] = newNode;
            return newNode;
        }

        private Node getChild(int position) {
            assert (position < this.nodes.length);
            return this.nodes[position];
        }

        private void ensureCapacity(int capacity) {
            if (capacity > this.nodes.length) {
                this.grow();
            }
        }

        private void grow() {
            int newCapacity = this.nodes.length + 10;
            this.nodes = Arrays.copyOf(this.nodes, newCapacity);
        }

        public String toString() {
            if (this.size == 0) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            builder.append(": [").append(this.nodes[0]);
            for (int i = 1; i < this.size; ++i) {
                builder.append(',').append(this.nodes[i]);
            }
            builder.append(']');
            return builder.toString();
        }

        public boolean isLeaf() {
            return this.size == 0;
        }

        abstract void collectLeaves(List<T> var1);

        public List<T> leaves() {
            LinkedList leaves = new LinkedList();
            this.collectLeaves(leaves);
            return leaves;
        }

        public abstract List<Node> path();
    }

    static class BreadthFirstTreeIterator<T>
    implements Iterator<T> {
        private final ArrayDeque<Node> stack = new ArrayDeque();
        private Node current;
        private int cursor = 0;

        public BreadthFirstTreeIterator(Node tree) {
            this.current = tree;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != this.current.size || !this.stack.isEmpty();
        }

        @Override
        public T next() {
            ContentNode node;
            if (this.cursor >= this.current.size && this.stack.isEmpty()) {
                throw new NoSuchElementException();
            }
            if (this.cursor == this.current.size) {
                this.current = this.stack.removeLast();
                this.cursor = 0;
            }
            if (!(node = (ContentNode)this.current.getChild(this.cursor)).isLeaf()) {
                this.stack.addFirst(node);
            }
            ++this.cursor;
            return node.content;
        }
    }

    class ContentNode
    extends Node {
        private final Node parent;
        private final T content;

        public ContentNode(Node parent, T content) {
            this.parent = parent;
            this.content = content;
        }

        @Override
        public String toString() {
            return this.content + super.toString();
        }

        @Override
        void collectLeaves(List<T> collectedLeaves) {
            if (this.isLeaf()) {
                collectedLeaves.add(this.content);
            } else {
                for (int i = 0; i < this.size; ++i) {
                    this.nodes[i].collectLeaves(collectedLeaves);
                }
            }
        }

        @Override
        public List<Node> path() {
            List<Node> ancestors = this.parent.path();
            ancestors.add(this);
            return ancestors;
        }
    }
}

