/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.collect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Guards;
import org.atlanmod.commons.collect.Path;

@ParametersAreNonnullByDefault
public class TreeMap<K, V> {
    private final Node root = new RootNode();

    public V put(Path<K> keys, V value) {
        return this.root.put(Guards.checkNotNull(keys), Guards.checkNotNull(value));
    }

    public Optional<V> get(Path<K> keys) {
        return this.root.get(Guards.checkNotNull(keys));
    }

    public String toString() {
        return this.root.toString();
    }

    class RootNode
    extends Node {
        RootNode() {
        }

        @Override
        public String toString() {
            return "root" + super.toString();
        }
    }

    abstract class Node {
        private List<ContentNode> nodes = Collections.emptyList();

        Node() {
        }

        public V put(Path<K> keys, V value) {
            Object key = keys.head();
            int position = this.indexOf(key);
            ContentNode child = position < 0 ? this.addChild(key) : this.nodes.get(position);
            if (keys.size() == 1) {
                child.setValue(value);
            } else {
                child.put(keys.tail(), value);
            }
            return value;
        }

        public Optional<V> get(Path<K> keys) {
            Object key = keys.head();
            int position = this.indexOf(key);
            if (position < 0) {
                return Optional.empty();
            }
            ContentNode child = this.nodes.get(position);
            return keys.size() == 1 ? child.getValue() : child.get(keys.tail());
        }

        private int indexOf(K key) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                ContentNode each = this.nodes.get(i);
                if (!each.key.equals(key)) continue;
                return i;
            }
            return -1;
        }

        private ContentNode addChild(K key) {
            assert (key != null);
            ContentNode newNode = new ContentNode(this, key);
            this.nodes().add(newNode);
            return newNode;
        }

        private List<ContentNode> nodes() {
            if (this.nodes.isEmpty()) {
                this.nodes = new ArrayList<ContentNode>(3);
            }
            return this.nodes;
        }

        public String toString() {
            if (this.nodes.isEmpty()) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            builder.append(": [").append(this.nodes.get(0));
            for (int i = 1; i < this.nodes.size(); ++i) {
                builder.append(',').append(this.nodes.get(i));
            }
            builder.append(']');
            return builder.toString();
        }
    }

    class ContentNode
    extends Node {
        private final Node parent;
        private final K key;
        private V value;

        ContentNode(Node parent, K key) {
            assert (key != null);
            this.parent = parent;
            this.key = key;
        }

        void setValue(V value) {
            this.value = value;
        }

        Optional<V> getValue() {
            return Optional.ofNullable(this.value);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.key).append(": ").append(this.value).append(super.toString());
            return builder.toString();
        }
    }
}

