/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.function;

import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Guards;

@ParametersAreNonnullByDefault
public interface BiConverter<T, U, R>
extends BiFunction<T, U, R> {
    @Nonnull
    public static <T, U> BiConverter<T, U, T> identity() {
        return new BiConverter<T, U, T>(){

            @Override
            @Nonnull
            public T convert(T t2, U u) {
                return t2;
            }

            @Override
            @Nonnull
            public T revert(T t2, U u) {
                return t2;
            }
        };
    }

    @Nonnull
    public static <T, U, R> BiConverter<T, U, R> from(final BiFunction<? super T, ? super U, ? extends R> convertFunc, final BiFunction<? super R, ? super U, ? extends T> revertFunc) {
        Guards.checkNotNull(convertFunc, "convertFunc");
        Guards.checkNotNull(revertFunc, "revertFunc");
        return new BiConverter<T, U, R>(){

            @Override
            @Nonnull
            public R convert(T t2, U u) {
                return convertFunc.apply(t2, u);
            }

            @Override
            @Nonnull
            public T revert(R r, U u) {
                return revertFunc.apply(r, u);
            }
        };
    }

    @Override
    default public R apply(T t2, U u) {
        return this.convert(t2, u);
    }

    public R convert(T var1, U var2);

    public T revert(R var1, U var2);

    @Nonnull
    default public BiConverter<R, U, T> reverse() {
        return BiConverter.from(this::revert, this::convert);
    }
}

