/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.hash;

import java.security.MessageDigest;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.atlanmod.commons.Guards;
import org.atlanmod.commons.hash.HashCode;
import org.atlanmod.commons.primitive.Bytes;

@ParametersAreNonnullByDefault
@Immutable
final class BinaryHashCode
implements HashCode {
    private static final long serialVersionUID = -576482022539994714L;
    @Nonnull
    private final byte[] bytes;

    public BinaryHashCode(byte[] hashCode) {
        this.bytes = Guards.checkNotNull(hashCode, "hashCode");
    }

    @Override
    @Nonnegative
    public int bits() {
        return this.bytes.length * 8;
    }

    @Override
    @Nonnull
    public byte[] toBytes() {
        return (byte[])this.bytes.clone();
    }

    @Override
    public long toLong() {
        return Bytes.toLong(this.bytes);
    }

    @Override
    @Nonnull
    public String toHexString() {
        return Bytes.toStringBinary(this.bytes);
    }

    public int hashCode() {
        if (this.bits() >= 32) {
            return this.bytes[0] & 0xFF | (this.bytes[1] & 0xFF) << 8 | (this.bytes[2] & 0xFF) << 16 | (this.bytes[3] & 0xFF) << 24;
        }
        byte[] cloneBytes = this.toBytes();
        int value = cloneBytes[0] & 0xFF;
        for (int i = 1; i < cloneBytes.length; ++i) {
            value |= (cloneBytes[i] & 0xFF) << i * 8;
        }
        return value;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryHashCode that = (BinaryHashCode)o;
        return MessageDigest.isEqual(this.bytes, that.bytes);
    }

    public String toString() {
        return String.format("HashCode {%s}", this.toHexString());
    }
}

