/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.hash;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.hash.HashCode;
import org.atlanmod.commons.primitive.Booleans;
import org.atlanmod.commons.primitive.Chars;
import org.atlanmod.commons.primitive.Doubles;
import org.atlanmod.commons.primitive.Floats;
import org.atlanmod.commons.primitive.Ints;
import org.atlanmod.commons.primitive.Longs;
import org.atlanmod.commons.primitive.Shorts;
import org.atlanmod.commons.primitive.Strings;

@FunctionalInterface
@ParametersAreNonnullByDefault
public interface Hasher {
    @Nonnull
    default public HashCode hash(byte data) {
        return this.hash(new byte[]{data});
    }

    @Nonnull
    default public HashCode hash(boolean data) {
        return this.hash(Booleans.toBytes(data));
    }

    @Nonnull
    default public HashCode hash(char data) {
        return this.hash(Chars.toBytes(data));
    }

    @Nonnull
    default public HashCode hash(short data) {
        return this.hash(Shorts.toBytes(data));
    }

    @Nonnull
    default public HashCode hash(int data) {
        return this.hash(Ints.toBytes(data));
    }

    @Nonnull
    default public HashCode hash(long data) {
        return this.hash(Longs.toBytes(data));
    }

    @Nonnull
    default public HashCode hash(float data) {
        return this.hash(Floats.toBytes(data));
    }

    @Nonnull
    default public HashCode hash(double data) {
        return this.hash(Doubles.toBytes(data));
    }

    @Nonnull
    default public HashCode hash(String data) {
        return this.hash(Strings.toBytes(data));
    }

    @Nonnull
    public HashCode hash(byte[] var1);
}

