/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.hash;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Guards;
import org.atlanmod.commons.Throwables;
import org.atlanmod.commons.hash.BinaryHashCode;
import org.atlanmod.commons.hash.HashCode;
import org.atlanmod.commons.hash.Hasher;

@ParametersAreNonnullByDefault
final class NativeHasher
implements Hasher {
    @Nonnull
    private final MessageDigest digest;

    public NativeHasher(String algorithm) {
        Guards.checkNotNull(algorithm, "algorithm");
        this.digest = NativeHasher.create(algorithm);
    }

    @Nonnull
    private static MessageDigest create(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw Throwables.shouldNeverHappen(e);
        }
    }

    @Override
    @Nonnull
    public HashCode hash(byte[] data) {
        BinaryHashCode h2 = new BinaryHashCode(this.digest.digest(data));
        this.digest.reset();
        return h2;
    }
}

