/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.io;

import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Throwables;
import org.atlanmod.commons.annotation.Static;
import org.atlanmod.commons.io.UnsignedByte;
import org.atlanmod.commons.io.UnsignedInt;
import org.atlanmod.commons.io.UnsignedNumber;
import org.atlanmod.commons.io.UnsignedShort;
import org.atlanmod.commons.io.UnsignedVarInt;

@Static
@ParametersAreNonnullByDefault
public class Numbers {
    private Numbers() {
        throw Throwables.notInstantiableClass(this.getClass());
    }

    public static UnsignedNumber fromLong(long value) {
        if (value <= 255L) {
            return Numbers.ubyte(value);
        }
        if (value <= 65535L) {
            return Numbers.ushort(value);
        }
        return Numbers.uint(value);
    }

    public static UnsignedByte ubyte(long value) {
        return UnsignedByte.fromLong(value);
    }

    public static UnsignedShort ushort(long value) {
        return UnsignedShort.fromLong(value);
    }

    public static UnsignedInt uint(long value) {
        return UnsignedInt.fromLong(value);
    }

    public static UnsignedVarInt uvarint(long value) {
        return UnsignedVarInt.fromLong(value);
    }
}

