/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.io;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.atlanmod.commons.Guards;
import org.atlanmod.commons.io.UnsignedNumber;
import org.atlanmod.commons.io.UnsignedShort;

public class UnsignedByte
extends UnsignedNumber
implements Comparable<UnsignedByte> {
    public static final short MIN_VALUE = 0;
    public static final short MAX_VALUE = 255;
    public static final int SIZE = 8;
    public static final int BYTES = 1;
    public static final int UNSIGNED_BYTE_MASK = 255;
    private static final UnsignedByte[] cache = new UnsignedByte[256];
    protected final short value;

    protected UnsignedByte(short value) {
        Guards.checkGreaterThanOrEqualTo(value, (short)0);
        Guards.checkLessThanOrEqualTo(value, (short)255);
        this.value = value;
    }

    private static UnsignedByte valueOf(short value) {
        assert (value >= 0 && value <= 255);
        if (cache[value] == null) {
            UnsignedByte.cache[value] = new UnsignedByte(value);
        }
        return cache[value];
    }

    public static UnsignedByte fromByte(byte value) {
        short unsigned = (short)(value & 0xFF);
        return UnsignedByte.valueOf(unsigned);
    }

    public static UnsignedByte fromShort(short value) {
        Guards.checkArgument(value >= 0 && value <= 255);
        short unsigned = (short)(value & 0xFF);
        return UnsignedByte.valueOf(unsigned);
    }

    public static UnsignedByte fromInt(int value) {
        Guards.checkArgument(value >= 0 && value <= 255);
        short unsigned = (short)(value & 0xFF);
        return UnsignedByte.valueOf(unsigned);
    }

    public static UnsignedByte fromLong(long value) {
        Guards.checkArgument(value >= 0L && value <= 255L);
        short unsigned = (short)(value & 0xFFL);
        return UnsignedByte.valueOf(unsigned);
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean isLessThan(UnsignedByte other) {
        return this.value < other.value;
    }

    public boolean isZero() {
        return this.value == 0;
    }

    public UnsignedShort withLowByte(UnsignedByte lowByte) {
        return UnsignedShort.fromInt((this.value << 8) + (lowByte.value & 0xFF));
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UnsignedByte that = (UnsignedByte)obj;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public int compareTo(UnsignedByte other) {
        return Short.compare(this.value, other.value);
    }

    @Override
    @Nonnull
    public byte[] toBytes() {
        byte[] bytes = new byte[]{this.byteValue()};
        return bytes;
    }

    public static UnsignedByte fromBytes(byte[] bytes) {
        Guards.checkNotNull(bytes, "bytes");
        Guards.checkEqualTo(bytes.length, 1, "bytes has wrong size: %d", bytes.length);
        byte value = bytes[0];
        return UnsignedByte.fromByte(value);
    }
}

