/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.io;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.atlanmod.commons.Guards;
import org.atlanmod.commons.io.UnsignedNumber;

public class UnsignedInt
extends UnsignedNumber
implements Comparable<UnsignedInt> {
    public static final long MIN_VALUE = 0L;
    public static final long MAX_VALUE = 0xFFFFFFFFL;
    public static final int SIZE = 32;
    public static final int BYTES = 4;
    private static final long UNSIGNED_INT_MASK = 0xFFFFFFFFL;
    private final long value;

    private UnsignedInt(long value) {
        this.value = value;
    }

    public static UnsignedInt fromInt(int value) {
        return new UnsignedInt((long)value & 0xFFFFFFFFL);
    }

    public static UnsignedInt fromLong(long value) {
        Guards.checkArgument(value >= 0L && value <= 0xFFFFFFFFL);
        long unsigned = value & 0xFFFFFFFFL;
        return new UnsignedInt(unsigned);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UnsignedInt that = (UnsignedInt)obj;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public int compareTo(UnsignedInt other) {
        return Long.compare(this.value, other.value);
    }

    @Override
    @Nonnull
    public byte[] toBytes() {
        int length = 4;
        int value = this.intValue();
        byte[] bytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int shift = 8 * (4 - i - 1);
            bytes[i] = (byte)(value >> shift);
        }
        return bytes;
    }

    public static UnsignedInt fromBytes(byte[] bytes) {
        Guards.checkNotNull(bytes, "bytes");
        Guards.checkEqualTo(bytes.length, 4, "bytes has wrong size: %d", bytes.length);
        int value = 0;
        int length = 3;
        for (int i = 3; i >= 0; --i) {
            value |= bytes[i] << 8 * (3 - i);
        }
        return UnsignedInt.fromInt(value);
    }
}

