/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.io.serializer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillNotClose;
import org.atlanmod.commons.Guards;
import org.atlanmod.commons.io.serializer.AbstractBinarySerializer;

@ParametersAreNonnullByDefault
final class ObjectBinarySerializer<T>
extends AbstractBinarySerializer<T> {
    private static final long serialVersionUID = 1069734448451637293L;

    ObjectBinarySerializer() {
    }

    @Override
    @Nonnull
    public byte[] serialize(T t2) {
        return FST.asByteArray(t2);
    }

    @Override
    @Nonnull
    public T deserialize(byte[] data) {
        return (T)FST.asObject(data);
    }

    @Override
    public void serialize(T t2, @WillNotClose DataOutput out) throws IOException {
        Guards.checkInstanceOf(t2, Serializable.class, "Requires a Serializable payload but received an object of type %s", t2.getClass().getName());
        if (out instanceof ObjectOutput) {
            this.serialize(t2, (ObjectOutput)out);
        } else if (out instanceof OutputStream) {
            this.serialize(t2, (OutputStream)((Object)out));
        } else {
            throw new IllegalArgumentException(String.format("Unknown stream of type %s", out.getClass().getName()));
        }
    }

    @Override
    @Nonnull
    public T deserialize(@WillNotClose DataInput in) throws IOException {
        if (in instanceof ObjectInput) {
            return this.deserialize((ObjectInput)in);
        }
        if (in instanceof InputStream) {
            return this.deserialize((InputStream)((Object)in));
        }
        throw new IllegalArgumentException(String.format("Unknown stream of type %s", in.getClass().getName()));
    }

    private void serialize(T t2, @WillNotClose ObjectOutput out) throws IOException {
        out.writeObject(t2);
    }

    @Override
    @Nonnull
    private T deserialize(@WillNotClose ObjectInput in) throws IOException {
        try {
            return (T)in.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }
}

