/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.io.serializer;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Throwables;
import org.atlanmod.commons.function.Converter;

@ParametersAreNonnullByDefault
public interface Serializer<T, U>
extends Converter<T, U> {
    @Override
    @Nonnull
    default public U convert(T t2) {
        try {
            return this.serialize(t2);
        }
        catch (IOException e) {
            throw Throwables.shouldNeverHappen(e);
        }
    }

    @Override
    @Nonnull
    default public T revert(U data) {
        try {
            return this.deserialize(data);
        }
        catch (IOException e) {
            throw Throwables.shouldNeverHappen(e);
        }
    }

    @Nonnull
    public U serialize(T var1) throws IOException;

    @Nonnull
    public T deserialize(U var1) throws IOException;
}

