/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.mutable;

import javax.annotation.Nonnull;
import org.atlanmod.commons.mutable.Mutable;

public class MutableInteger
extends Number
implements Comparable<MutableInteger>,
Mutable<Integer> {
    private int value;

    public MutableInteger() {
    }

    public MutableInteger(int newValue) {
        this();
        this.value = newValue;
    }

    public void set(int newValue) {
        this.value = newValue;
    }

    public int get() {
        return this.value;
    }

    public void increment() {
        ++this.value;
    }

    public int incrementAndGet() {
        ++this.value;
        return this.value;
    }

    public int getAndIncrement() {
        int oldValue = this.value++;
        return oldValue;
    }

    public void decrement() {
        --this.value;
    }

    public int decrementAndGet() {
        --this.value;
        return this.value;
    }

    public int getAndDecrement() {
        int oldValue = this.value--;
        return oldValue;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MutableInteger)) {
            return false;
        }
        MutableInteger that = (MutableInteger)other;
        return this.value == that.value;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public void setValue(Integer newValue) {
        this.value = newValue;
    }

    @Override
    public int compareTo(@Nonnull MutableInteger other) {
        return Integer.compare(this.value, other.value);
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }
}

