/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.predicate;

import org.atlanmod.commons.predicate.Predicate;
import org.atlanmod.commons.predicate.PredicateContext;

public class LongPredicate
extends Predicate {
    private static final String PATTERN = "\nExpecting value (%d) to be %s (%d)";
    private final long value;

    public LongPredicate(PredicateContext context, long value) {
        super(context);
        this.value = value;
    }

    public LongPredicate isZero() {
        if (this.value != 0L) {
            this.context.send(PATTERN, this.value, "exactly", 0);
        }
        return this;
    }

    public LongPredicate isGreaterThan(long other) {
        if (this.value <= other) {
            this.context.send(PATTERN, this.value, "greater than", other);
        }
        return this;
    }

    public LongPredicate isGreaterThanOrEqualTo(long other) {
        if (this.value < other) {
            this.context.send(PATTERN, this.value, "greater than or equal to", other);
        }
        return this;
    }

    public LongPredicate isLessThan(long other) {
        if (this.value >= other) {
            this.context.send(PATTERN, this.value, "less than", other);
        }
        return this;
    }

    public LongPredicate isLessThanOrEqualTo(long other) {
        if (this.value > other) {
            this.context.send(PATTERN, this.value, "less than or equal to", other);
        }
        return this;
    }

    public LongPredicate isBetween(long first, long last) {
        if (this.value < first || this.value > last) {
            this.context.send("\nExpecting value (%d) to be %s (%d) and (%d)", this.value, "between", first, last);
        }
        return this;
    }

    public LongPredicate isEqualTo(long other) {
        if (this.value != other) {
            this.context.send(PATTERN, this.value, "equal to", other);
        }
        return this;
    }

    public LongPredicate isDifferentFrom(long other) {
        if (this.value == other) {
            this.context.send(PATTERN, this.value, "different from", other);
        }
        return this;
    }
}

