/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.predicate;

import java.util.Objects;
import org.atlanmod.commons.predicate.Predicate;
import org.atlanmod.commons.predicate.PredicateContext;

public class ObjectPredicate<Yourself extends ObjectPredicate, T>
extends Predicate {
    private static final String PATTERN = "\nExpecting value (%s) to be %s (%s)";
    final T value;
    Yourself y;

    public ObjectPredicate(PredicateContext context, T value) {
        super(context);
        this.value = value;
    }

    public Yourself isNull() {
        if (!Objects.isNull(this.value)) {
            this.context.send(PATTERN, this.value, "null", "");
        }
        return this.me();
    }

    public Yourself isNotNull() {
        if (Objects.isNull(this.value)) {
            this.context.send(PATTERN, this.value, "non null", "");
        }
        return this.me();
    }

    public Yourself isEqualTo(T other) {
        if (!this.value.equals(other)) {
            this.context.send(PATTERN, this.value, "equal to", other);
        }
        return this.me();
    }

    public Yourself isDifferentFrom(T other) {
        if (this.value.equals(other)) {
            this.context.send(PATTERN, this.value, "different from", other);
        }
        return this.me();
    }

    public Yourself me() {
        return (Yourself)this;
    }
}

