/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.primitive;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Guards;
import org.atlanmod.commons.Throwables;
import org.atlanmod.commons.annotation.Static;
import org.atlanmod.commons.primitive.Longs;

@Static
@ParametersAreNonnullByDefault
public final class Doubles {
    private Doubles() {
        throw Throwables.notInstantiableClass(this.getClass());
    }

    @Nonnull
    public static byte[] toBytes(double value) {
        return Longs.toBytes(Double.doubleToLongBits(value));
    }

    @Nonnull
    public static byte[] toBytes(Double value) {
        Guards.checkNotNull(value, "value");
        return Doubles.toBytes((double)value);
    }
}

