/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.primitive;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Guards;
import org.atlanmod.commons.Throwables;
import org.atlanmod.commons.annotation.Static;

@Static
@ParametersAreNonnullByDefault
public final class Ints {
    private Ints() {
        throw Throwables.notInstantiableClass(this.getClass());
    }

    @Nonnull
    public static byte[] toBytes(int value) {
        byte[] bytes = new byte[4];
        int length = 3;
        for (int i = 3; i >= 0; --i) {
            bytes[i] = (byte)(value >> 8 * (3 - i));
        }
        return bytes;
    }

    @Nonnull
    public static byte[] toBytes(Integer value) {
        Guards.checkNotNull(value, "value");
        return Ints.toBytes((int)value);
    }
}

