/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.primitive;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.atlanmod.commons.Throwables;

public final class Primitives {
    @Nonnull
    private static final Set<Class<?>> PRIMITIVE_TYPES = new HashSet();

    private Primitives() {
        throw Throwables.notInstantiableClass(this.getClass());
    }

    public static boolean isPrimitiveOrString(Class<?> type) {
        return Primitives.isPrimitive(type) || type == String.class || Primitives.isBoxed(type);
    }

    public static boolean isBoxed(Class<?> type) {
        return PRIMITIVE_TYPES.contains(type);
    }

    public static boolean isPrimitive(Class<?> type) {
        return type.isPrimitive();
    }

    static {
        PRIMITIVE_TYPES.add(Boolean.class);
        PRIMITIVE_TYPES.add(Character.class);
        PRIMITIVE_TYPES.add(Byte.class);
        PRIMITIVE_TYPES.add(Short.class);
        PRIMITIVE_TYPES.add(Integer.class);
        PRIMITIVE_TYPES.add(Long.class);
        PRIMITIVE_TYPES.add(Float.class);
        PRIMITIVE_TYPES.add(Double.class);
        PRIMITIVE_TYPES.add(Void.class);
    }
}

