/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.primitive;

import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Guards;
import org.atlanmod.commons.Throwables;
import org.atlanmod.commons.annotation.Static;

@Static
@ParametersAreNonnullByDefault
public final class Strings {
    @Nonnull
    public static final String EMPTY = "";
    @Nonnull
    public static final String SPACE = " ";
    @Nonnull
    public static final String LR = System.lineSeparator();
    @Nonnull
    private static final Predicate<String> IS_BINARY = Pattern.compile("^[0-9a-f]+$", 2).asPredicate();

    private Strings() {
        throw Throwables.notInstantiableClass(this.getClass());
    }

    public static boolean isNullOrEmpty(@Nullable String s2) {
        return Objects.isNull(s2) || s2.isEmpty();
    }

    @Nonnull
    public static String nullToEmpty(@Nullable String s2) {
        return Objects.isNull(s2) ? EMPTY : s2;
    }

    @CheckForNull
    public static String emptyToNull(@Nullable String s2) {
        return Strings.isNullOrEmpty(s2) ? null : s2;
    }

    @Nonnull
    public static byte[] toBytes(String value) {
        Guards.checkNotNull(value, "value");
        try {
            return value.getBytes(StandardCharsets.UTF_8);
        }
        catch (UnsupportedCharsetException e) {
            throw Throwables.shouldNeverHappen(e);
        }
    }

    @Nonnull
    public static byte[] toBytesBinary(String value) {
        Guards.checkNotNull(value, "value");
        Guards.checkEqualTo(value.length() % 2, 0, "value.length (%d) must be pair", value.length());
        byte[] bytes = new byte[value.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)((Strings.toHexDigit(value.charAt(i * 2)) << 4) + Strings.toHexDigit(value.charAt(i * 2 + 1)));
        }
        return bytes;
    }

    @Nonnegative
    private static int toHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        char lower = Character.toLowerCase(c);
        if (lower >= 'a' && lower <= 'f') {
            return lower - 97 + 10;
        }
        throw new IllegalArgumentException(String.format("Unexpected hex digit: %c", Character.valueOf(c)));
    }

    public static boolean isBinary(String value) {
        return !Strings.isNullOrEmpty(value) && IS_BINARY.test(value);
    }
}

