/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.time;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Guards;

@ParametersAreNonnullByDefault
public final class Stopwatch {
    private Instant start;
    private Instant end;
    private boolean isRunning;

    private Stopwatch() {
    }

    @Nonnull
    public static Stopwatch createUnstarted() {
        return new Stopwatch();
    }

    @Nonnull
    public static Stopwatch createStarted() {
        return new Stopwatch().start();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    @Nonnull
    public Stopwatch start() {
        Guards.checkState(!this.isRunning, "This stopwatch is already running");
        this.isRunning = true;
        this.start = Instant.now();
        return this;
    }

    @Nonnull
    public Stopwatch stop() {
        Guards.checkState(this.isRunning, "This stopwatch is already stopped");
        this.isRunning = false;
        this.end = Instant.now();
        return this;
    }

    @Nonnull
    public Stopwatch reset() {
        this.start = null;
        this.end = null;
        this.isRunning = false;
        return this;
    }

    @Nonnull
    public Duration elapsed() {
        if (this.isRunning) {
            return Duration.between(this.start, Instant.now());
        }
        if (Objects.isNull(this.start)) {
            return Duration.ofNanos(0L);
        }
        return Duration.between(this.start, this.end);
    }
}

