/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.tuple;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Pair<L, R>
implements Serializable {
    public final L left;
    public final R right;

    private Pair(L left, R right) {
        this.left = left;
        this.right = right;
    }

    @Nonnull
    public static <L, R> Pair<L, R> of(L left, R right) {
        return new Pair<L, R>(left, right);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        return this.left.equals(pair.left) && this.right.equals(pair.right);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }

    public Pair<R, L> swap() {
        return new Pair<R, L>(this.right, this.left);
    }
}

