/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons;

import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Throwables;
import org.atlanmod.commons.annotation.Static;
import org.atlanmod.commons.predicate.BooleanPredicate;
import org.atlanmod.commons.predicate.CollectionPredicate;
import org.atlanmod.commons.predicate.ComparablePredicate;
import org.atlanmod.commons.predicate.IntPredicate;
import org.atlanmod.commons.predicate.LongPredicate;
import org.atlanmod.commons.predicate.ObjectPredicate;
import org.atlanmod.commons.predicate.PredicateContext;
import org.atlanmod.commons.predicate.StringPredicate;
import org.jetbrains.annotations.Contract;

@Static
@ParametersAreNonnullByDefault
public class Guards {
    private static final PredicateContext CONTEXT = new GuardContext();
    @Nullable
    private static final String NO_MESSAGE = null;
    @Nonnull
    private static final Object[] NO_PARAMS = new Object[0];

    private Guards() {
        throw Throwables.notInstantiableClass(this.getClass());
    }

    @Contract(value="false -> fail", pure=true)
    public static void checkArgument(boolean expression) {
        Guards.checkArgument(expression, NO_MESSAGE);
    }

    @Contract(value="false, _ -> fail", pure=true)
    public static void checkArgument(boolean expression, String message) {
        Guards.checkArgument(expression, message, NO_PARAMS);
    }

    @Contract(value="false, _, _ -> fail", pure=true)
    public static void checkArgument(boolean expression, String pattern, Object ... args) {
        if (!expression) {
            throw new IllegalArgumentException(Guards.format(pattern, args));
        }
    }

    @Contract(value="false -> fail", pure=true)
    public static void checkState(boolean expression) {
        Guards.checkState(expression, NO_MESSAGE);
    }

    @Contract(value="false, _ -> fail", pure=true)
    public static void checkState(boolean expression, String message) {
        Guards.checkState(expression, message, NO_PARAMS);
    }

    @Contract(value="false, _, _ -> fail", pure=true)
    public static void checkState(boolean expression, String pattern, Object ... args) {
        if (!expression) {
            throw new IllegalStateException(Guards.format(pattern, args));
        }
    }

    @Nonnull
    @Contract(value="null -> fail", pure=true)
    public static <T> T checkNotNull(@Nullable T reference) {
        return Guards.checkNotNull(reference, NO_MESSAGE);
    }

    @Nonnull
    @Contract(value="null, _ -> fail", pure=true)
    public static <T> T checkNotNull(@Nullable T reference, String message) {
        return Guards.checkNotNull(reference, message, NO_PARAMS);
    }

    @Nonnull
    @Contract(value="null, _, _ -> fail", pure=true)
    public static <T> T checkNotNull(@Nullable T reference, String pattern, Object ... args) {
        if (null == reference) {
            throw new NullPointerException(Guards.format(pattern, args));
        }
        return reference;
    }

    @Nonnull
    public static <C extends Collection<? extends T>, T> C checkNotContainsNull(C collection) {
        return Guards.checkNotContainsNull(collection, "the collection contains at least one null element");
    }

    @Nonnull
    public static <C extends Collection<? extends T>, T> C checkNotContainsNull(C collection, String message) {
        return Guards.checkNotContainsNull(collection, message, NO_PARAMS);
    }

    @Nonnull
    public static <C extends Collection<? extends T>, T> C checkNotContainsNull(C collection, String pattern, Object ... args) {
        Guards.checkNotNull(collection, "collection");
        if (collection.contains(null)) {
            throw new NullPointerException(Guards.format(pattern, args));
        }
        return collection;
    }

    @Nonnull
    public static <T> T checkInstanceOf(T reference, Class<?> type) {
        return Guards.checkInstanceOf(reference, type, "object must be instance of '%s', but was '%s'", type.getName(), reference.getClass());
    }

    @Nonnull
    public static <T> T checkInstanceOf(T reference, Class<?> type, String message) {
        return Guards.checkInstanceOf(reference, type, message, NO_PARAMS);
    }

    @Nonnull
    public static <T> T checkInstanceOf(T reference, Class<?> type, String pattern, Object ... args) {
        Guards.checkNotNull(reference, "reference");
        Guards.checkNotNull(type, "type");
        if (!type.isInstance(reference)) {
            throw new IllegalArgumentException(Guards.format(pattern, args));
        }
        return reference;
    }

    public static <T> T checkEqualTo(@Nullable T value, @Nullable T other) {
        return Guards.checkEqualTo(value, other, "value (%s) must be equal to %s", value, other);
    }

    public static <T> T checkEqualTo(@Nullable T value, @Nullable T other, String message) {
        return Guards.checkEqualTo(value, other, message, NO_PARAMS);
    }

    public static <T> T checkEqualTo(@Nullable T value, @Nullable T other, String pattern, Object ... args) {
        if (!Objects.equals(value, other)) {
            throw new IllegalArgumentException(Guards.format(pattern, args));
        }
        return value;
    }

    @Nonnull
    public static <C extends Comparable<C>> C checkGreaterThan(C value, C lowerBoundExclusive) {
        return Guards.checkGreaterThan(value, lowerBoundExclusive, "value (%s) must be greater than %s", value, lowerBoundExclusive);
    }

    @Nonnull
    public static <C extends Comparable<C>> C checkGreaterThan(C value, C lowerBoundExclusive, String message) {
        return Guards.checkGreaterThan(value, lowerBoundExclusive, message, NO_PARAMS);
    }

    @Nonnull
    public static <C extends Comparable<C>> C checkGreaterThan(C value, C lowerBoundExclusive, String pattern, Object ... args) {
        Guards.checkNotNull(value, "value");
        Guards.checkNotNull(lowerBoundExclusive, "lowerBoundExclusive");
        if (value.compareTo(lowerBoundExclusive) <= 0) {
            throw new IllegalArgumentException(Guards.format(pattern, args));
        }
        return value;
    }

    @Nonnull
    public static <C extends Comparable<C>> C checkGreaterThanOrEqualTo(C value, C lowerBoundInclusive) {
        return Guards.checkGreaterThanOrEqualTo(value, lowerBoundInclusive, "value (%s) must not be less than %s", value, lowerBoundInclusive);
    }

    @Nonnull
    public static <C extends Comparable<C>> C checkGreaterThanOrEqualTo(C value, C lowerBoundInclusive, String message) {
        return Guards.checkGreaterThanOrEqualTo(value, lowerBoundInclusive, message, NO_PARAMS);
    }

    @Nonnull
    public static <C extends Comparable<C>> C checkGreaterThanOrEqualTo(C value, C lowerBoundInclusive, String pattern, Object ... args) {
        Guards.checkNotNull(value, "value");
        Guards.checkNotNull(lowerBoundInclusive, "lowerBoundInclusive");
        if (value.compareTo(lowerBoundInclusive) < 0) {
            throw new IllegalArgumentException(Guards.format(pattern, args));
        }
        return value;
    }

    @Nonnull
    public static <C extends Comparable<C>> C checkLessThan(C value, C upperBoundExclusive) {
        return Guards.checkLessThan(value, upperBoundExclusive, "value (%s) must be less than %s", value, upperBoundExclusive);
    }

    @Nonnull
    public static <C extends Comparable<C>> C checkLessThan(C value, C upperBoundExclusive, String message) {
        return Guards.checkLessThan(value, upperBoundExclusive, message, NO_PARAMS);
    }

    @Nonnull
    public static <C extends Comparable<C>> C checkLessThan(C value, C upperBoundExclusive, String pattern, Object ... args) {
        Guards.checkNotNull(value, "value");
        Guards.checkNotNull(upperBoundExclusive, "upperBoundExclusive");
        if (value.compareTo(upperBoundExclusive) >= 0) {
            throw new IllegalArgumentException(Guards.format(pattern, args));
        }
        return value;
    }

    @Nonnull
    public static <C extends Comparable<C>> C checkLessThanOrEqualTo(C value, C upperBoundInclusive) {
        return Guards.checkLessThanOrEqualTo(value, upperBoundInclusive, "value (%s) must not be greater than %s", value, upperBoundInclusive);
    }

    @Nonnull
    public static <C extends Comparable<C>> C checkLessThanOrEqualTo(C value, C upperBoundInclusive, String message) {
        return Guards.checkLessThanOrEqualTo(value, upperBoundInclusive, message, NO_PARAMS);
    }

    @Nonnull
    public static <C extends Comparable<C>> C checkLessThanOrEqualTo(C value, C upperBoundInclusive, String pattern, Object ... args) {
        Guards.checkNotNull(value, "value");
        Guards.checkNotNull(upperBoundInclusive, "upperBoundInclusive");
        if (value.compareTo(upperBoundInclusive) > 0) {
            throw new IllegalArgumentException(Guards.format(pattern, args));
        }
        return value;
    }

    @Nonnegative
    public static int checkElementIndex(@Nonnegative int index, @Nonnegative int size) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(Guards.format("index (%d) must not be negative", index));
        }
        if (size < 0) {
            throw new IllegalArgumentException(Guards.format("size (%d) must not be negative", size));
        }
        if (index >= size) {
            throw new IndexOutOfBoundsException(Guards.format("index (%d) must be less than size (%d)", index, size));
        }
        return index;
    }

    @Nonnegative
    public static int checkPositionIndex(@Nonnegative int index, @Nonnegative int size) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(Guards.format("index (%d) must not be negative", index));
        }
        if (size < 0) {
            throw new IllegalArgumentException(Guards.format("size (%d) must not be negative", size));
        }
        if (index > size) {
            throw new IndexOutOfBoundsException(Guards.format("index (%d) must not be greater than size (%d)", index, size));
        }
        return index;
    }

    public static IntPredicate checkThat(int expression) {
        return new IntPredicate(CONTEXT, expression);
    }

    public static LongPredicate checkThat(long expression) {
        return new LongPredicate(CONTEXT, expression);
    }

    public static BooleanPredicate checkThat(boolean expression) {
        return new BooleanPredicate(CONTEXT, expression);
    }

    public static StringPredicate checkThat(String expression) {
        return new StringPredicate(CONTEXT, expression);
    }

    public static ObjectPredicate<ObjectPredicate, Object> checkThat(Object expression) {
        return new ObjectPredicate<ObjectPredicate, Object>(CONTEXT, expression);
    }

    public static ComparablePredicate<ComparablePredicate, Comparable> checkThat(Comparable expression) {
        return new ComparablePredicate<ComparablePredicate, Comparable>(CONTEXT, expression);
    }

    public static CollectionPredicate<CollectionPredicate, Collection> checkThat(Collection<?> expression) {
        return new CollectionPredicate<CollectionPredicate, Collection>(CONTEXT, expression);
    }

    @Nullable
    private static String format(String pattern, Object ... args) {
        return null != pattern ? String.format(pattern, args) : null;
    }

    public static class GuardException
    extends IllegalArgumentException {
        public GuardException(String message) {
            super(message);
        }
    }

    static class GuardContext
    implements PredicateContext {
        private GuardContext() {
        }

        @Override
        public void send(String pattern, Object ... args) {
            throw new GuardException(String.format(pattern, args));
        }
    }
}

