/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons;

import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class LazyBoolean {
    @Nonnull
    private final BooleanSupplier loadFunction;
    private boolean value;
    private volatile boolean isLoaded;

    private LazyBoolean(BooleanSupplier loadFunction) {
        this.loadFunction = loadFunction;
    }

    @Nonnull
    public static LazyBoolean of(boolean value) {
        return new LazyBoolean(() -> value);
    }

    @Nonnull
    public static LazyBoolean with(BooleanSupplier loadFunction) {
        return new LazyBoolean(loadFunction);
    }

    public boolean getAsBoolean() {
        if (!this.isLoaded) {
            this.load();
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        BooleanSupplier booleanSupplier = this.loadFunction;
        synchronized (booleanSupplier) {
            if (!this.isLoaded) {
                this.update(this.loadFunction.getAsBoolean());
            }
        }
    }

    public void update(boolean newValue) {
        this.value = newValue;
        this.isLoaded = true;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void unload() {
        this.value = false;
        this.isLoaded = false;
    }
}

