/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons;

import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class LazyDouble {
    @Nonnull
    private final DoubleSupplier loadFunction;
    private double value;
    private volatile boolean isLoaded;

    private LazyDouble(DoubleSupplier loadFunction) {
        this.loadFunction = loadFunction;
    }

    @Nonnull
    public static LazyDouble of(double value) {
        return new LazyDouble(() -> value);
    }

    @Nonnull
    public static LazyDouble with(DoubleSupplier loadFunction) {
        return new LazyDouble(loadFunction);
    }

    public double getAsDouble() {
        if (!this.isLoaded) {
            this.load();
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        DoubleSupplier doubleSupplier = this.loadFunction;
        synchronized (doubleSupplier) {
            if (!this.isLoaded) {
                this.update(this.loadFunction.getAsDouble());
            }
        }
    }

    public void update(double newValue) {
        this.value = newValue;
        this.isLoaded = true;
    }

    public void update(DoubleUnaryOperator updateOperator) {
        this.update(updateOperator.applyAsDouble(this.getAsDouble()));
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void ifLoaded(DoubleConsumer consumer) {
        if (this.isLoaded) {
            consumer.accept(this.value);
        }
    }

    public void unload() {
        this.value = 0.0;
        this.isLoaded = false;
    }
}

