/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons;

import java.util.Collection;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Guards;
import org.atlanmod.commons.Throwables;
import org.atlanmod.commons.annotation.Static;
import org.atlanmod.commons.predicate.BooleanPredicate;
import org.atlanmod.commons.predicate.CollectionPredicate;
import org.atlanmod.commons.predicate.ComparablePredicate;
import org.atlanmod.commons.predicate.IntPredicate;
import org.atlanmod.commons.predicate.LongPredicate;
import org.atlanmod.commons.predicate.ObjectPredicate;
import org.atlanmod.commons.predicate.PredicateContext;
import org.atlanmod.commons.predicate.StringPredicate;

@Static
@ParametersAreNonnullByDefault
public final class Preconditions {
    private static final PredicateContext CONTEXT = new PreconditionContext();

    private Preconditions() {
        throw Throwables.notInstantiableClass(this.getClass());
    }

    @Deprecated
    public static void checkArgument(boolean expression) {
        Guards.checkArgument(expression);
    }

    @Deprecated
    public static void checkArgument(boolean expression, String message) {
        Guards.checkArgument(expression, message);
    }

    @Deprecated
    public static void checkArgument(boolean expression, String pattern, Object ... args) {
        Guards.checkArgument(expression, pattern, args);
    }

    @Deprecated
    public static void checkState(boolean expression) {
        Guards.checkState(expression);
    }

    @Deprecated
    public static void checkState(boolean expression, String message) {
        Guards.checkState(expression, message);
    }

    @Deprecated
    public static void checkState(boolean expression, String pattern, Object ... args) {
        Guards.checkState(expression, pattern, args);
    }

    @Deprecated
    public static <T> T checkNotNull(@Nullable T reference) {
        return Guards.checkNotNull(reference);
    }

    @Deprecated
    public static <T> T checkNotNull(@Nullable T reference, String message) {
        return Guards.checkNotNull(reference, message);
    }

    @Deprecated
    public static <T> T checkNotNull(@Nullable T reference, String pattern, Object ... args) {
        return Guards.checkNotNull(reference, pattern, args);
    }

    @Deprecated
    public static <C extends Collection<? extends T>, T> C checkNotContainsNull(C collection) {
        return Guards.checkNotContainsNull(collection);
    }

    @Deprecated
    public static <C extends Collection<? extends T>, T> C checkNotContainsNull(C collection, String message) {
        return Guards.checkNotContainsNull(collection, message);
    }

    @Deprecated
    public static <C extends Collection<? extends T>, T> C checkNotContainsNull(C collection, String pattern, Object ... args) {
        return Guards.checkNotContainsNull(collection, pattern, args);
    }

    @Deprecated
    public static <T> T checkInstanceOf(T reference, Class<?> type) {
        return Guards.checkInstanceOf(reference, type);
    }

    @Deprecated
    public static <T> T checkInstanceOf(T reference, Class<?> type, String message) {
        return Guards.checkInstanceOf(reference, type, message);
    }

    @Deprecated
    public static <T> T checkInstanceOf(T reference, Class<?> type, String pattern, Object ... args) {
        return Guards.checkInstanceOf(reference, type, pattern, args);
    }

    @Deprecated
    public static <T> T checkEqualTo(@Nullable T value, @Nullable T other) {
        return Guards.checkEqualTo(value, other);
    }

    @Deprecated
    public static <T> T checkEqualTo(@Nullable T value, @Nullable T other, String message) {
        return Guards.checkEqualTo(value, other, message);
    }

    @Deprecated
    public static <T> T checkEqualTo(@Nullable T value, @Nullable T other, String pattern, Object ... args) {
        return Guards.checkEqualTo(value, other, pattern, args);
    }

    @Deprecated
    public static <C extends Comparable<C>> C checkGreaterThan(C value, C lowerBoundExclusive) {
        return Guards.checkGreaterThan(value, lowerBoundExclusive);
    }

    @Deprecated
    public static <C extends Comparable<C>> C checkGreaterThan(C value, C lowerBoundExclusive, String message) {
        return Guards.checkGreaterThan(value, lowerBoundExclusive, message);
    }

    @Deprecated
    public static <C extends Comparable<C>> C checkGreaterThan(C value, C lowerBoundExclusive, String pattern, Object ... args) {
        return Guards.checkGreaterThan(value, lowerBoundExclusive, pattern, args);
    }

    @Deprecated
    public static <C extends Comparable<C>> C checkGreaterThanOrEqualTo(C value, C lowerBoundInclusive) {
        return Guards.checkGreaterThanOrEqualTo(value, lowerBoundInclusive);
    }

    @Deprecated
    public static <C extends Comparable<C>> C checkGreaterThanOrEqualTo(C value, C lowerBoundInclusive, String message) {
        return Guards.checkGreaterThanOrEqualTo(value, lowerBoundInclusive, message);
    }

    @Deprecated
    public static <C extends Comparable<C>> C checkGreaterThanOrEqualTo(C value, C lowerBoundInclusive, String pattern, Object ... args) {
        return Guards.checkGreaterThanOrEqualTo(value, lowerBoundInclusive, pattern, args);
    }

    @Deprecated
    public static <C extends Comparable<C>> C checkLessThan(C value, C upperBoundExclusive) {
        return Guards.checkLessThan(value, upperBoundExclusive);
    }

    @Deprecated
    public static <C extends Comparable<C>> C checkLessThan(C value, C upperBoundExclusive, String message) {
        return Guards.checkLessThan(value, upperBoundExclusive, message);
    }

    @Deprecated
    public static <C extends Comparable<C>> C checkLessThan(C value, C upperBoundExclusive, String pattern, Object ... args) {
        return Guards.checkLessThan(value, upperBoundExclusive, pattern, args);
    }

    @Deprecated
    public static <C extends Comparable<C>> C checkLessThanOrEqualTo(C value, C upperBoundInclusive) {
        return Guards.checkLessThanOrEqualTo(value, upperBoundInclusive);
    }

    @Deprecated
    public static <C extends Comparable<C>> C checkLessThanOrEqualTo(C value, C upperBoundInclusive, String message) {
        return Guards.checkLessThanOrEqualTo(value, upperBoundInclusive, message);
    }

    @Deprecated
    public static <C extends Comparable<C>> C checkLessThanOrEqualTo(C value, C upperBoundInclusive, String pattern, Object ... args) {
        return Guards.checkLessThanOrEqualTo(value, upperBoundInclusive, pattern, args);
    }

    @Deprecated
    public static int checkElementIndex(@Nonnegative int index, @Nonnegative int size) {
        return Guards.checkElementIndex(index, size);
    }

    @Deprecated
    public static int checkPositionIndex(@Nonnegative int index, @Nonnegative int size) {
        return Guards.checkPositionIndex(index, size);
    }

    public static IntPredicate requireThat(int expression) {
        return new IntPredicate(CONTEXT, expression);
    }

    public static LongPredicate requireThat(long expression) {
        return new LongPredicate(CONTEXT, expression);
    }

    public static BooleanPredicate requireThat(boolean expression) {
        return new BooleanPredicate(CONTEXT, expression);
    }

    public static StringPredicate requireThat(String expression) {
        return new StringPredicate(CONTEXT, expression);
    }

    public static ObjectPredicate<ObjectPredicate, Object> requireThat(Object expression) {
        return new ObjectPredicate<ObjectPredicate, Object>(CONTEXT, expression);
    }

    public static ComparablePredicate<ComparablePredicate, Comparable> requireThat(Comparable expression) {
        return new ComparablePredicate<ComparablePredicate, Comparable>(CONTEXT, expression);
    }

    public static CollectionPredicate<CollectionPredicate, Collection> requireThat(Collection<?> expression) {
        return new CollectionPredicate<CollectionPredicate, Collection>(CONTEXT, expression);
    }

    public static class PreconditionError
    extends AssertionError {
        public PreconditionError(String message) {
            super((Object)message);
        }
    }

    static class PreconditionContext
    implements PredicateContext {
        private PreconditionContext() {
        }

        @Override
        public void send(String pattern, Object ... args) {
            throw new PreconditionError(String.format(pattern, args));
        }
    }
}

