/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.annotation.Static;

@Static
@ParametersAreNonnullByDefault
public final class Throwables {
    private Throwables() {
        throw Throwables.notInstantiableClass(this.getClass());
    }

    @Nonnull
    public static RuntimeException shouldNeverHappen(Throwable e) {
        return new IllegalStateException("This should never have happened", e);
    }

    @Nonnull
    public static RuntimeException notImplementedYet(String methodName) {
        return new UnsupportedOperationException(String.format("Not implemented yet: %s", methodName));
    }

    @Nonnull
    public static RuntimeException notInstantiableClass(Class<?> type) {
        return new IllegalStateException(String.format("%s is not instantiable; this constructor should not be called", type.getSimpleName()));
    }
}

