/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.collect;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.atlanmod.commons.Guards;

public class Flags
implements Serializable {
    private byte[] bytes;

    public Flags(int size) {
        Guards.checkGreaterThanOrEqualTo(size, 0);
        int bytesLength = (int)Math.ceil((double)size / 8.0);
        this.bytes = new byte[bytesLength];
    }

    @Nonnull
    private Flags(byte[] bytes) {
        Guards.checkGreaterThanOrEqualTo(bytes.length, 0);
        this.bytes = Arrays.copyOf(bytes, bytes.length);
    }

    public void set(int index) {
        this.set(index, true);
    }

    public void set(int index, boolean value) {
        Guards.checkPositionIndex(index, this.bytes.length * 8);
        int position = index / 8;
        int shift = index % 8;
        if (value) {
            int n = position;
            this.bytes[n] = (byte)(this.bytes[n] | 1 << shift);
        } else {
            int n = position;
            this.bytes[n] = (byte)(this.bytes[n] & ~(1 << shift));
        }
    }

    public boolean get(int index) {
        Guards.checkPositionIndex(index, this.bytes.length * 8);
        int position = index / 8;
        int shift = index % 8;
        return (this.bytes[position] & 1 << shift) != 0;
    }

    public byte[] toBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    public void writeOn(ByteBuffer buffer) {
        assert (this.bytes.length < buffer.remaining()) : "ByteArray must have enough place for this Bit Set";
        buffer.put(this.bytes);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Flags that = (Flags)other;
        return Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public String toString() {
        return Arrays.toString(this.bytes);
    }

    public static Flags fromBytes(byte[] bytes) {
        return new Flags(bytes);
    }
}

