/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.collect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Guards;
import org.atlanmod.commons.collect.Path;
import org.jetbrains.annotations.Contract;

@ParametersAreNonnullByDefault
public class PathMap<K, V> {
    private final Node root = new RootNode();

    public V put(Path<K> keys, V value) {
        return this.root.put(Guards.checkNotNull(keys), Guards.checkNotNull(value));
    }

    @Contract(pure=true)
    public Optional<V> get(Path<K> keys) {
        return this.root.get(Guards.checkNotNull(keys));
    }

    public Optional<V> computeIfAbsent(Path<K> keys, Function<? super K, ? extends V> mappingFunction) {
        return this.root.computeIfAbsent(Guards.checkNotNull(keys), Guards.checkNotNull(mappingFunction));
    }

    public void apply(BiConsumer<V, V> consumer) {
        this.root.apply(consumer);
    }

    public String toString() {
        return this.root.toString();
    }

    class ContentNode
    extends Node {
        private final Node parent;
        private final K key;
        private V value;

        ContentNode(Node parent, K key) {
            assert (key != null);
            this.parent = parent;
            this.key = key;
        }

        Optional<V> getValue() {
            return Optional.ofNullable(this.value);
        }

        void setValue(V value) {
            this.value = value;
        }

        @Override
        public void apply(BiConsumer<V, V> consumer) {
            for (ContentNode each : this.nodes()) {
                consumer.accept(this.value, each.value);
                each.apply(consumer);
            }
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.key).append(": ").append(this.value).append(super.toString());
            return builder.toString();
        }
    }

    class RootNode
    extends Node {
        RootNode() {
        }

        @Override
        public void apply(BiConsumer<V, V> consumer) {
            for (ContentNode each : this.nodes()) {
                each.apply(consumer);
            }
        }

        @Override
        public String toString() {
            return "root" + super.toString();
        }
    }

    abstract class Node {
        private List<ContentNode> nodes = Collections.emptyList();

        Node() {
        }

        public V put(Path<K> keys, V value) {
            Object key = keys.head();
            int position = this.indexOf(key);
            ContentNode child = position < 0 ? this.addChild(key) : this.nodes.get(position);
            if (keys.size() == 1) {
                child.setValue(value);
            } else {
                child.put(keys.tail(), value);
            }
            return value;
        }

        public Optional<V> get(Path<K> keys) {
            Object key = keys.head();
            int position = this.indexOf(key);
            if (position < 0) {
                return Optional.empty();
            }
            ContentNode child = this.nodes.get(position);
            return keys.size() == 1 ? child.getValue() : child.get(keys.tail());
        }

        public Optional<V> computeIfAbsent(Path<K> keys, Function<? super K, ? extends V> mappingFunction) {
            ContentNode child;
            Object key = keys.head();
            int position = this.indexOf(key);
            if (position < 0) {
                child = this.addChild(key);
                child.setValue(mappingFunction.apply(key));
            } else {
                child = this.nodes.get(position);
            }
            if (keys.size() == 1) {
                return child.getValue();
            }
            return child.computeIfAbsent(keys.tail(), mappingFunction);
        }

        public abstract void apply(BiConsumer<V, V> var1);

        private int indexOf(K key) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                ContentNode each = this.nodes.get(i);
                if (!each.key.equals(key)) continue;
                return i;
            }
            return -1;
        }

        private ContentNode addChild(K key) {
            assert (key != null);
            ContentNode newNode = new ContentNode(this, key);
            this.nodes().add(newNode);
            return newNode;
        }

        List<ContentNode> nodes() {
            if (this.nodes.isEmpty()) {
                this.nodes = new ArrayList<ContentNode>(3);
            }
            return this.nodes;
        }

        public String toString() {
            if (this.nodes.isEmpty()) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            builder.append(": [").append(this.nodes.get(0));
            for (int i = 1; i < this.nodes.size(); ++i) {
                builder.append(',').append(this.nodes.get(i));
            }
            builder.append(']');
            return builder.toString();
        }
    }
}

