/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.concurrent;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.atlanmod.commons.Guards;
import org.atlanmod.commons.Throwables;
import org.atlanmod.commons.annotation.Static;
import org.atlanmod.commons.concurrent.DirectExecutorService;
import org.atlanmod.commons.concurrent.MoreThreads;
import org.atlanmod.commons.log.Log;

@Static
@ParametersAreNonnullByDefault
public final class MoreExecutors {
    private MoreExecutors() {
        throw Throwables.notInstantiableClass(this.getClass());
    }

    @Nonnull
    public static ExecutorService newDirectPool() {
        return new DirectExecutorService();
    }

    @Nonnull
    public static ExecutorService newFixedThreadPool() {
        return MoreExecutors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    }

    @Nonnull
    public static ExecutorService newFixedThreadPool(String name) {
        return MoreExecutors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), name);
    }

    @Nonnull
    public static ExecutorService newFixedThreadPool(int nThreads) {
        return MoreExecutors.newFixedThreadPool(nThreads, null);
    }

    @Nonnull
    public static ExecutorService newFixedThreadPool(int nThreads, @Nullable String name) {
        ExecutorService service = Executors.newFixedThreadPool(nThreads, MoreThreads.newThreadFactory(name));
        return MoreExecutors.shutdownAtExit(service, 100L, TimeUnit.MILLISECONDS, true);
    }

    public static void shutdown(ExecutorService service, long timeout, TimeUnit unit, boolean executeUnstarted) {
        List<Runnable> unstartedTasks = MoreExecutors.shutdown(service, timeout, unit);
        if (executeUnstarted) {
            unstartedTasks.forEach(Runnable::run);
        } else if (!unstartedTasks.isEmpty()) {
            Log.warn("{0} pending execution(s) will not be executed", unstartedTasks.size());
        }
    }

    @Nonnull
    public static List<Runnable> shutdown(ExecutorService service, long timeout, TimeUnit unit) {
        Guards.checkNotNull(service, "service");
        Guards.checkNotNull(unit, "unit");
        Guards.checkGreaterThanOrEqualTo(timeout, 0L, "timeout (%d) must not be negative", timeout);
        if (!service.isShutdown() && !service.isTerminated()) {
            try {
                service.shutdown();
                if (service.awaitTermination(timeout, unit)) {
                    return service.shutdownNow();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    @Nonnull
    public static ExecutorService shutdownAtExit(ExecutorService service, long timeout, TimeUnit unit, boolean executeUnstarted) {
        Guards.checkNotNull(service, "service");
        Guards.checkNotNull(unit, "unit");
        Guards.checkGreaterThanOrEqualTo(timeout, 0L, "timeout (%d) must not be negative", timeout);
        MoreThreads.executeAtExit(() -> MoreExecutors.shutdown(service, timeout, unit, executeUnstarted));
        return service;
    }
}

