/*
 * Decompiled with CFR 0.152.
 */
package org.atlanmod.commons.io;

import javax.annotation.Nonnull;
import org.atlanmod.commons.Guards;
import org.atlanmod.commons.io.UnsignedNumber;

public class UnsignedShort
extends UnsignedNumber
implements Comparable<UnsignedShort> {
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 65535;
    public static final int SIZE = 16;
    public static final int BYTES = 2;
    private static final int UNSIGNED_SHORT_MASK = 65535;
    private final int value;

    protected UnsignedShort(int value) {
        Guards.checkLessThanOrEqualTo(value, 65535);
        Guards.checkGreaterThanOrEqualTo(value, 0);
        this.value = value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object other) {
        if (other instanceof UnsignedShort) {
            return this.value == ((UnsignedShort)other).value;
        }
        return false;
    }

    public int hashCode() {
        return UnsignedShort.hashCode(this.value);
    }

    public static int hashCode(int value) {
        return value;
    }

    public static UnsignedShort fromShort(short value) {
        return new UnsignedShort(value & 0xFFFF);
    }

    public static UnsignedShort fromInt(int value) {
        Guards.checkLessThanOrEqualTo(value, 65535);
        Guards.checkGreaterThanOrEqualTo(value, 0);
        int unsigned = value & 0xFFFF;
        return new UnsignedShort(unsigned);
    }

    public static UnsignedShort fromLong(long value) {
        Guards.checkArgument(value <= 65535L, "value");
        Guards.checkArgument(value >= 0L, "value");
        int unsigned = (int)value & 0xFFFF;
        return new UnsignedShort(unsigned);
    }

    @Override
    public int compareTo(UnsignedShort other) {
        return Integer.compare(this.value, other.value);
    }

    public boolean isLessThan(UnsignedShort other) {
        return this.value < other.value;
    }

    public boolean isZero() {
        return this.value == 0;
    }

    @Override
    @Nonnull
    public byte[] toBytes() {
        byte[] bytes = new byte[2];
        boolean length = true;
        for (int i = 1; i >= 0; --i) {
            bytes[i] = (byte)(this.shortValue() >> 16 * (1 - i));
        }
        return bytes;
    }

    public static UnsignedShort fromBytes(byte[] bytes) {
        Guards.checkNotNull(bytes, "bytes");
        Guards.checkEqualTo(bytes.length, 2, "bytes has wrong size: %d", bytes.length);
        short value = 0;
        boolean length = true;
        for (int i = 1; i >= 0; --i) {
            value = (short)(value | bytes[i] << 8 * (1 - i));
        }
        return UnsignedShort.fromShort(value);
    }
}

